PROCEDURE APMultPartsFromSelected;

{Makes a worksheet of individual AP Multicable Parts for Label printing}

{Put together by Trevor Gooch, July 2023}

		 
CONST
kAPMulticable = 'AP Multicable';				{ AP Multicable Data Record }
	kCableID = 'CableID';						{ Text }
	kCableType = 'CableType';					{ Text - Popup Menu Item }
	kPartsList = 'PartsList';					{ Static Text }
	kPart1 = 'Part 1';							{ Real - Coordinate Displacement }
	kPart2 = 'Part 2';							{ Real - Coordinate Displacement }
	kPart3 = 'Part 3';							{ Real - Coordinate Displacement }
	kPart4 = 'Part 4';							{ Real - Coordinate Displacement }
	kPart5 = 'Part 5';							{ Real - Coordinate Displacement }
	kPart6 = 'Part 6';							{ Real - Coordinate Displacement }
	kPart7 = 'Part 7';							{ Real - Coordinate Displacement }
	kPart8 = 'Part 8';							{ Real - Coordinate Displacement }
	kPart9 = 'Part 9';							{ Real - Coordinate Displacement }



Type
	APMultiDetail = structure
		obj : handle;
		id,cabletype,Multpartslist,p1,p2,p3,p4,p5,p6,p7,p8,p9: string;
		qtyParts: real;
end;
	
VAR

	NumMults,PartsCount,row, i,j: Integer;
	WSH	:Handle;
	PartLen : string;
	APMulti : dynarray[] of APMultiDetail;



FUNCTION CountDelim(str, ch :STRING) :integer;
	{Countes the instances of a delimiter in a string}
	{Returns 0 if invalid}
	
	
	var
		i,cnt : integer;
	
	begin
		cnt :=0;
		if ((len(str)>0) and (Len(ch)=1)) then
			Begin
			for i:= 1 to len(str) do begin
				If(copy(str,i,1)=ch) then
					cnt:=cnt+1;
				End;
			End;
		CountDelim:=cnt;
	End;	
	


Procedure populate_array(h : handle);
	var
		str : string;
		partcnt : integer;
	
	Begin
		str := GetRField(h,kAPMulticable,KPartslist);
		if(len(str)>0) then	
			partcnt:=CountDelim(GetRField(h,kAPMulticable,kPartsList),',')+1;

		APMulti[i].obj := h;
		APMulti[i].id := GetRField(h,kAPMulticable,kCableID);
		APMulti[i].cabletype := GetRField(h,kAPMulticable,kCableType);
		APMulti[i].Multpartslist := getRField(h,kAPMulticable,kPartsList);
		APMulti[i].qtyParts := partcnt;
		APMulti[i].p1 := GetRField(h,kAPMulticable,kPart1);
		APMulti[i].p2 := GetRField(h,kAPMulticable,kPart2);
		APMulti[i].p3 := GetRField(h,kAPMulticable,kPart3);
		APMulti[i].p4 := GetRField(h,kAPMulticable,kPart4);
		APMulti[i].p5 := GetRField(h,kAPMulticable,kPart5);
		APMulti[i].p6 := GetRField(h,kAPMulticable,kPart6);
		APMulti[i].p7 := GetRField(h,kAPMulticable,kPart7);
		APMulti[i].p8 := GetRField(h,kAPMulticable,kPart8);
		APMulti[i].p9 := GetRField(h,kAPMulticable,kPart9);
		i:=i+1;
	End;
	


Procedure AddtheParts(h: handle);
{tally's all of the parts}
	var
		PartsList : string;

	Begin
		partslist := GetRField(h,kAPMulticable,KPartslist);
		if(len(Partslist)>0) then	
			PartsCount:=PartsCount+CountDelim(GetRField(h,kAPMulticable,kPartsList),',')+1;
	end;


{===================Main Program===================}
BEGIN
	PartsCount:=0;
	NumMults:= Count((((PON=kAPMulticable) & (SEL=TRUE))));
	
	Allocate APMulti[1..NumMults];
	
	i:=1;
	ForEachObject(populate_array, (((PON=kAPMulticable) & (SEL=TRUE))));

	SortArray(APMulti,NumMults,2);

	ForEachObject(AddTheParts,(((PON=kAPMulticable) & (SEL=TRUE))));
	
	WSH:=CreateWS(Concat('AP MultiParts',' ',Date(2,1)),PartsCount+5,10);
	SetWSPlacement(WSH,200,200,800,850);
	
	SetWSCellTextFormat(WSH,1,1,1,4,33,18,1); {sets the Sheet title text format}	
	SetWSCellFormula(WSH,1,1,1,1,Concat('AP Multicable Parts',' ',Date(2,1)));

	SetWSCellTextFormat(WSH,3,1,3,4,33,12,1); {sets the column header text format}
	SetWSCellFormula(WSH,3,1,3,1,'Multicable');
	SetWSCellFormula(WSH,3,2,3,2,'Type');
	SetWSCellFormula(WSH,3,3,3,3,'Part');		
	SetWSCellFormula(WSH,3,4,3,4,'Len');

	row:=4;	
	i:=1;
	While i<=NumMults do
		begin
			j:=1;
			While j<=APMulti[i].qtyParts do
				BEGIN	
					Case j of
					1 : partlen:=APMulti[i].p1;
					2 : partlen:=APMulti[i].p2;
					3 : partlen:=APMulti[i].p3;
					4 : partlen:=APMulti[i].p4;
					5 : partlen:=APMulti[i].p5;
					6 : partlen:=APMulti[i].p6;
					7 : partlen:=APMulti[i].p7;
					8 : partlen:=APMulti[i].p8;
					9 : partlen:=APMulti[i].p9;
					End;
							
					{ Populate the worksheet }
					SetWSCellFormula(WSH,row,1,row,1,APMulti[i].id);
					SetWSCellFormula(WSH,row,2,row,2,concat(APMulti[i].cabletype));
					SetWSCellFormula(WSH,row,3,row,3,concat(j,' of ',APMulti[i].qtyParts));
					SetWSCellFormula(WSH,row,4,row,4,Concat(partlen));
					
					j:=j+1;
					Row:=row+1;
				End;	
			i:=i+1;
		End;			
		
		ShowWS(WSH,True);
		SetTopVisibleWS(WSH);	
END;

Run(APMultPartsFromSelected);